@extends('admin.layouts.master')

@section('main-content')
<section class="section">
    <div class="section-header">
        <h1>{{ __('order.orders') }}</h1>
        {{ Breadcrumbs::render('orders/view') }}
    </div>

    <div class="section-body">

        <div id="invoice-print" class="d-none">
            <div class="invoicePrint">
                <style>
                    .invoicePrint {
                        max-width: 390px;
                        width: 100%;
                        margin: auto;
                        padding: 8px;
                        font-family: 'OpenSauceOne', sans-serif;
                    }

                    p {
                        margin-top: 4px;
                        margin-bottom: 0px;
                    }

                    h2,
                    h3 {
                        font-size: 32px;
                        font-weight: bolder;
                        margin-top: 4px;
                        margin-bottom: 2px;
                    }

                    h3 {
                        font-size: 28px;
                        margin-bottom: 8px;
                    }

                    p,
                    td {
                        font-size: 16px;
                    }

                    table {
                        width: 100%;
                        margin-top: 4px;
                        margin-bottom: 4px;
                    }

                    .invoiceFooter p {
                        font-size: 14px;
                        font-weight: 400;

                    }

                    .invoiceFooter small {
                        font-size: 12px;
                        margin-top: 24px;
                    }

                    .border-dashed {
                        border-top: 1px dashed gainsboro;
                    }

                    .text-center {
                        text-align: center;
                    }

                    .text-start {
                        text-align: start;
                    }

                    .text-end {
                        text-align: end;
                    }

                    .align-top {
                        vertical-align: top;
                    }

                    .min-w-80 {
                        min-width: 80px;
                        width: 80px;
                    }

                    ul {
                        list-style: none;
                    }
                </style>
                <div class="text-center pb-2">
                    <h2> {{ setting('site_name') ? setting('site_name') : '' }}
                        {{ __('frontend.restaurant') }}</h2>
                    <h3>{{ __('frontend.food_ordering_delivery_system') }}</h3>
                    <p> {{ __('frontend.email') }}: {{ setting('site_email') }}</p>
                    <p class="mt-2"> {{ __('frontend.tel') }}:
                        {{ setting('site_phone_number') }}
                    </p>
                </div>
                <div class="border-dashed">
                    <ul class="mb-0">
                        <li class="pt-1">
                            <td class="text-start">#{{ $order->order_code }}</td>
                        </li>
                        <li class="pb-1 d-flex justify-content-between align-items-center">
                            <span class="text-start mt-1"> {{ $order->created_at->format('d M Y') }}</span>
                            <span class="text-end">{{ $order->created_at->format('h:i A') }}</span>
                        </li>
                    </ul>
                </div>
                <div class="border-dashed">
                    <ul class="d-flex align-items-center justify-content-between mb-0">
                        <li class="text-start pb-3">
                            {{ __('frontend.quantity') }}</li>
                        </li>
                        <li class="text-start pb-3">
                            {{ __('frontend.item') }} </li>
                        <li class="text-end pb-3">
                            {{ __('frontend.totals') }}</li>
                    </ul>

                    @foreach ($items as $itemKey => $item)
                        <ul class="d-flex align-items-start justify-content-between mb-0">
                            <li class="text-start align-top pb-2 min-w-80"> {{ $item->quantity }}</li>
                            <li class="text-start pb-2"> {{ $item->menuItem->name }}
                                {{ $item->variation ? ' ( ' . $item->variation['name'] . ' )' : '' }}
                                @if ($item->options)
                                    <p>
                                        @foreach (json_decode($item->options, true) as $option)
                                            <span>{{ $option['name'] }}</span>
                                        @endforeach
                                    </p>
                                @endif
                            </li>
                            <li class="text-end align-top pb-2 min-w-80">
                                {{ currencyFormat($item->item_total) }}
                            </li>
                        </ul>
                    @endforeach

                </div>
                <div class="border-dashed ps-5">
                    <ul class="ms-4 mb-0">
                        <li class="d-flex align-items-center justify-content-between">
                            <span class="text-start"> {{ __('frontend.subtotal') }}:</span>
                            <span class="text-end align-top">{{ currencyFormat($order->sub_total) }}</span>
                        </li>
                        @if ($order->discount && $order->discount->amount > 0 && Schema::hasColumn('coupons', 'slug'))
                            <li class="d-flex align-items-center justify-content-between">
                                <span class="text-start"> {{ __('frontend.discount') }}:
                                </span>
                                <span class="text-end align-top">
                                    {{ currencyFormat($order->discount->amount) }}</span>
                            </li>
                        @endif
                        <li class="d-flex align-items-center justify-content-between">
                            <span class="text-start"> {{ __('frontend.delivery_charge') }}:
                            </span>
                            <span class="text-end align-top">{{ currencyFormat($order->delivery_charge) }}
                            </span>
                        </li>
                        <li class="d-flex align-items-center justify-content-between">
                            <span class="text-start"> {{ __('frontend.total') }}:</span>
                            <span class="text-end align-top"> {{ currencyFormat($order->total) }}</span>
                        </li>
                    </ul>
                </div>
                <div class="border-dashed">
                    <ul class="pt-1 pb-1 mb-0">
                        <li class="d-flex align-items-center">
                            <span>{{ __('levels.order_type') }}:</span>
                            <span>{{ $order->getOrderType }}</span>
                        </li>
                        <li class="d-flex align-items-center">
                            <span>{{ __('frontend.payment_status') }}:</span>
                            <span>{{ trans('payment_status.' . $order->payment_status) ?? null }}</span>
                        </li>
                    </ul>
                </div>
                <div class="border-dashed">
                    <ul class="pt-1 pb-1 mb-0">
                        <li class="d-flex">
                            <span class="pb-2 min-w-80">{{ __('levels.customer') }}:</span>
                            <span>{{ $order->user->name ?? '' }}</span>
                        </li>
                        <li class="d-flex">
                            <span class="pb-2 min-w-80">{{ __('frontend.phone') }}: </span>
                            <span>{{ $order->mobile ?? '' }}</span>
                        </li>
                        <li class="d-flex">
                            <span class="pb-2 min-w-80">{{ __('frontend.address') }}:</span>
                            <span>{{ orderAddress($order->address) }}</span>
                        </li>
                    </ul>
                </div>
                <p class="text-center border-dashed pt-2"> {{ __('levels.thank_you') }} </p>
                <div class="text-end invoiceFooter mt-4">
                    <small>{{ setting('site_name') ? setting('site_name') : '' }}</small>
                    <p>{{ __('frontend.restaurant') }} {{ __('frontend.food_ordering_delivery_system') }}
                    </p>
                </div>
            </div>
        </div>


        <div class="invoice">
            <div class="invoice-print">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="invoice-title">
                            <h2>{{ __('order.invoice') }}</h2>
                            <div class="invoice-number">{{ __('order.order') }} #{{ $order->order_code }}</div>
                        </div>
                        <hr>
                        <div class="row">
                            <div class="col-md-6">
                                <address>
                                    {{ $order->restaurant->name }}<br>
                                    {{ $order->restaurant->address ?? null }}<br>
                                    {{ __('restaurant.opens_at').' '.date('h:i A', strtotime($order->restaurant->opening_time)) .' - '. __('restaurant.closes_at').' '.date('h:i A', strtotime($order->restaurant->closing_time)) }}
                                </address>
                            </div>
                            <div class="col-md-6 text-md-right">
                                <address>
                                    <strong>{{ __('order.billed_to') }}:</strong><br>
                                    {{ $order->user->name ?? null }}<br>
                                    @if(auth()->user()->myrole !=3)
                                    {{ __('levels.phone').':'. $order->user->phone ?? null }}<br>
                                    {{ orderAddress($order->address) }}
                                    @else
                                    {{ __('levels.email').':'. substr($order->user->email, 0, 2).'****'.substr($order->user->email, strpos($order->user->email, "@"))}}<br>
                                    {{ __('levels.phone').':'. substr($order->user->phone, 0, 2).'********'.substr($order->user->phone, -2)}}<br>
                                    {{ orderAddress($order->address) }}
                                    @endif
                                </address>

                                <address>
                                    <strong>{{ __('order.order_date') }}:</strong><br>
                                    {{ \Carbon\Carbon::parse($order->created_at)->format('d M Y, h:i A') }}<br><br>
                                </address>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row mt-4">
                    <div class="col-md-12">
                        <div class="section-title">{{ __('order.order_summary') }}</div>
                        <p class="section-lead">{{ __('order.all_items_here_cannot_be_deleted') }}</p>
                        <div class="table-responsive">
                            <table class="table table-striped table-hover table-md">
                                <tr>
                                    <th data-width="40">{{ __('#') }}</th>
                                    <th>{{ __('order.item') }}</th>
                                    <th class="text-center">{{ __('levels.price') }}</th>
                                    <th class="text-center">{{ __('levels.quantity') }}</th>
                                    <th class="text-right">{{ __('levels.totals') }}</th>
                                </tr>
                                @foreach($items as $itemKey => $item)
                                <tr>
                                    <td>{{ $itemKey+1 }}</td>
                                    <td>{{ $item->menuItem->name }}
                                        @if(!blank($item->variation))
                                        <small class="basic-color">{{ ' ( '.json_decode($item->variation,true)['name'].' )'}}</small>
                                        @endif

                                        @if(!blank($item->options))
                                        @foreach (json_decode($item->options,true) as $option)
                                        <br>
                                        <small><span>-- &nbsp; &nbsp;{{ $option['name'] }}</span></small>
                                        @endforeach
                                        @endif
                                    </td>
                                    <td class="text-center">{{ currencyFormat($item->unit_price) }}</td>
                                    <td class="text-center">{{ $item->quantity }} </td>
                                    <td class="text-right">{{ currencyFormat($item->item_total) }}</td>
                                </tr>
                                @if(!blank($item->instructions))
                                    <tr>
                                        <td class="pt-0 pb-4" colspan="5"><strong> {{ __('levels.instructions') }}</strong>  {{ $item->instructions}}  </td>
                                    </tr>
                                @endif

                                @endforeach
                            </table>
                        </div>
                        <div class="row mt-4">
                            <div class="col-lg-8">
                                <div class="section-title">{{ __('levels.delivery') }} : {{ trans('order_status.'.$order->status) }}</div>
                                <div class="section-title">{{ __('levels.order_type') }} : {{ $order->getOrderType }}</div>
                                <div class="section-title">{{ __('levels.payment_status') }} : {{ trans('payment_status.'.$order->payment_status) }}</div>
                                <div class="section-title">{{ __('order.payment_method') }} : {{ trans('payment_method.'.$order->payment_method) }}</div>
                            </div>
                            <div class="col-lg-4 text-right">
                                @if ($order->discount && $order->discount->amount > 0 && Schema::hasColumn('coupons', 'slug'))
                                    <div class="invoice-detail-item">
                                        <div class="invoice-detail-name">{{ __('levels.discount') }}</div>
                                        <div class="invoice-detail-value">{{ currencyFormat($order->discount->amount) }}</div>
                                    </div>
                                @endif

                                <div class="invoice-detail-item">
                                    <div class="invoice-detail-name">{{ __('levels.sub_total') }}</div>
                                    <div class="invoice-detail-value">{{ currencyFormat($order->sub_total) }}</div>
                                </div>
                                <div class="invoice-detail-item">
                                    <div class="invoice-detail-name">{{ __('levels.delivery_charge') }}</div>
                                    <div class="invoice-detail-value">{{ currencyFormat($order->delivery_charge) }}</div>
                                </div>
                                <hr class="mt-2 mb-2">
                                <div class="invoice-detail-item">
                                    <div class="invoice-detail-name"> {{ __('levels.total') }}</div>
                                    <div class="invoice-detail-value invoice-detail-value-lg">{{ currencyFormat($order->total) }}</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="text-md-right">
                @if($order->attachment)
                <a class="btn btn-info m-2" href="{{ route('admin.orders.order-file', $order->id) }}"><i class="fa fa-arrow-circle-down"></i> {{ __('levels.download') }}</a>
                @endif

                <button onclick="printDiv('invoice-print')" class="btn btn-warning btn-icon icon-left"><i class="fas fa-print"></i> {{ __('levels.print') }}</button>
            </div>
        </div>


    </div>
</section>
@endsection

@section('scripts')
<script src="{{ asset('assets/js/print.js') }}"></script>
@endsection
